#ifndef __IToolTipListener__
#define __IToolTipListener__

#include <Basics/CString.hpp>
using Exponent::Basics::CString;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Listeners
		{
			/**
			 * @interface IToolTipListener IToolTipListener.hpp
			 * @brief Allows a handler to respond to tool tip requests for display information
			 *
			 * @date 18/03/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: IToolTipListener.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			interface IToolTipListener
			{

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 */
				IToolTipListener() { }
				
				/**
				 * Destruction
				 */
				virtual ~IToolTipListener() { }

//	===========================================================================

				/**
				 * Get the text to put in the tool tip window
				 * @param value On return is filled with the tool tip text
				 * @param idOfRequestingControl The id of the control that you want the tool tip for
				 */
				virtual void getToolTipText(CString &value, const long idOfRequestingControl) = 0;

//	===========================================================================
			};
		}
	}
}
#endif	// End of IToolTipListener.hpp